<?php
header('Content-Type: application/json');
require __DIR__ . '/common.php';

$action = $_REQUEST['action'] ?? '';
$op     = $_REQUEST['op']     ?? '';
$jobId  = $_REQUEST['job_id'] ?? '';

list($server, $conn) = madmin_require_server_from_request();

function madmin_valid_op(string $op): bool {
    return in_array($op, [
        'update',
        'upgrade',
        'full-upgrade',
        'dist-upgrade',
        'autoremove',
        'update-upgrade'
    ], true);
}

function madmin_remote_cmd($conn, string $cmd): string {
    return madmin_ssh_exec_capture($conn, $cmd);
}

switch ($action) {

    case 'start':
        if (!madmin_valid_op($op)) {
            madmin_json_error('Invalid operation');
        }

        $cmdMap = [
            'update'         => "apt-get -o Acquire::Retries=3 update",
            'upgrade'        => "DEBIAN_FRONTEND=noninteractive apt-get -y -o Dpkg::Use-Pty=0 upgrade",
            'full-upgrade'   => "DEBIAN_FRONTEND=noninteractive apt-get -y -o Dpkg::Use-Pty=0 full-upgrade",
            'dist-upgrade'   => "DEBIAN_FRONTEND=noninteractive apt-get -y -o Dpkg::Use-Pty=0 dist-upgrade",
            'autoremove'     => "DEBIAN_FRONTEND=noninteractive apt-get -y autoremove",
            'update-upgrade' => "apt-get -o Acquire::Retries=3 update && DEBIAN_FRONTEND=noninteractive apt-get -y -o Dpkg::Use-Pty=0 upgrade"
        ];

        $ts     = date('YmdHis');
        $jobId  = $op . '-' . $ts;
        $log    = "/tmp/admops_{$jobId}.log";
        $pidf   = "/tmp/admops_{$jobId}.pid";
        $remote =
            "LOG=\"$log\"; PIDF=\"$pidf\"; " .
            "echo \"[admops] Start $op @\$(date -Is)\" > \"\$LOG\"; " .
            "nohup sh -c '" . $cmdMap[$op] . " >> \"\$LOG\" 2>&1' & echo \$! > \"\$PIDF\"; echo STARTED";

        $res = madmin_remote_cmd($conn, $remote);

        echo json_encode([
            'status'   => (strpos($res, 'STARTED') !== false) ? 'ok' : 'error',
            'op'       => $op,
            'job_id'   => $jobId,
            'log'      => $log,
            'pid_file' => $pidf,
            'raw'      => $res
        ]);
        break;

    case 'status':
        if ($jobId === '') madmin_json_error('Missing job_id');
        $log  = "/tmp/admops_{$jobId}.log";
        $pidf = "/tmp/admops_{$jobId}.pid";

        $check = madmin_remote_cmd($conn,
            "pid=0; [ -f \"$pidf\" ] && pid=\$(cat \"$pidf\" 2>/dev/null || echo 0); " .
            "[ \"\$pid\" -gt 0 ] && [ -d \"/proc/\$pid\" ] && echo RUNNING || echo STOPPED");
        $running = trim($check) === 'RUNNING';

        $tail = madmin_remote_cmd($conn,
            "[ -f \"$log\" ] && tail -n 200 \"$log\" || true");

        $pct = madmin_remote_cmd($conn,
            "[ -f \"$log\" ] && grep -oE '[0-9]{1,3}%' \"$log\" | tail -n 1 || true");
        $progress = 0;
        if (preg_match('/(\d{1,3})%/', $pct, $m)) {
            $progress = min(99, (int)$m[1]);
        } elseif (!$running && $tail !== '') {
            $progress = 100;
        }

        echo json_encode([
            'status'   => 'ok',
            'job_id'   => $jobId,
            'running'  => $running,
            'progress' => $progress,
            'log_tail' => ($tail === '' ? [] : explode("\n", $tail))
        ]);
        break;

    case 'stop':
        if ($jobId === '') madmin_json_error('Missing job_id');
        $pidf = "/tmp/admops_{$jobId}.pid";
        $out  = madmin_remote_cmd($conn,
            "if [ -f \"$pidf\" ]; then pid=\$(cat \"$pidf\" 2>/dev/null || echo 0); " .
            "[ \"\$pid\" -gt 0 ] && [ -d \"/proc/\$pid\" ] && kill \"\$pid\" && echo KILLED || echo NOTRUNNING; " .
            "else echo NOPID; fi");
        echo json_encode(['status' => 'ok', 'job_id' => $jobId, 'result' => $out]);
        break;

    case 'clean':
        if ($jobId === '') madmin_json_error('Missing job_id');
        $log  = "/tmp/admops_{$jobId}.log";
        $pidf = "/tmp/admops_{$jobId}.pid";
        madmin_remote_cmd($conn, "rm -f \"$log\" \"$pidf\"");
        echo json_encode(['status' => 'ok', 'job_id' => $jobId]);
        break;

    case 'list':
        $out = madmin_remote_cmd($conn, "ls -1t /tmp/admops_*.log 2>/dev/null || true");
        $jobs = [];
        if ($out !== '') {
            $lines = explode("\n", trim($out));
            foreach ($lines as $line) {
                $line = trim($line);
                if ($line === '') continue;
                if (!preg_match('/admops_(.+)\.log$/', $line, $m)) continue;
                $jid = $m[1];
                $pidf = "/tmp/admops_{$jid}.pid";
                $status = madmin_remote_cmd($conn,
                    "pid=0; [ -f \"$pidf\" ] && pid=\$(cat \"$pidf\" 2>/dev/null||echo 0); " .
                    "[ \"\$pid\" -gt 0 ] && [ -d \"/proc/\$pid\" ] && echo RUNNING || echo DONE");
                $mtime = madmin_remote_cmd($conn, "stat -c %y \"$line\" 2>/dev/null || echo ''");
                $jobs[] = [
                    'job_id'  => $jid,
                    'log'     => $line,
                    'running' => (trim($status) === 'RUNNING'),
                    'mtime'   => $mtime
                ];
            }
        }
        echo json_encode(['status' => 'ok', 'jobs' => $jobs]);
        break;

    case 'log':
        if ($jobId === '') madmin_json_error('Missing job_id');
        $log = "/tmp/admops_{$jobId}.log";
        $content = madmin_remote_cmd($conn,
            "[ -f \"$log\" ] && tail -n 500 \"$log\" || echo 'Kein Log gefunden.'");
        echo json_encode(['status' => 'ok', 'job_id' => $jobId, 'log' => $content]);
        break;

    default:
        madmin_json_error('Unknown action');
}
