<?php
header('Content-Type: application/json');
$config = require __DIR__ . '/config.php';
$serverKey = $_GET['server'] ?? '';
$action = $_GET['action'] ?? 'list'; // list | start | stop | restart | logs
$target = $_GET['service'] ?? '';

if (!isset($config['servers'][$serverKey])) {
  echo json_encode(['error' => 'Unknown server']);
  exit;
}

$server = $config['servers'][$serverKey];

// SSH-Verbindung
$connection = @ssh2_connect($server['host'], 22);
if (!$connection) { echo json_encode(['error' => 'SSH connection failed']); exit; }
if (!@ssh2_auth_password($connection, $server['user'], $server['pass'])) {
  echo json_encode(['error' => 'Authentication failed']); exit;
}

// SSH-Helper
function ssh2_exec_capture($conn, $cmd) {
  $stream = ssh2_exec($conn, $cmd);
  stream_set_blocking($stream, true);
  $result = stream_get_contents($stream);
  fclose($stream);
  return trim($result);
}

// -------------------
// Aktionen
// -------------------

switch ($action) {

  case 'start':
  case 'stop':
  case 'restart':
    if (empty($target)) {
      echo json_encode(['error' => 'No service specified']);
      exit;
    }
    $cmd = "sudo systemctl $action $target 2>&1";
    $output = ssh2_exec_capture($connection, $cmd);
    echo json_encode(['status' => 'ok', 'service' => $target, 'action' => $action, 'output' => $output]);
    exit;

  case 'logs':
    if (empty($target)) {
      echo json_encode(['error' => 'No service specified']);
      exit;
    }
    $cmd = "sudo journalctl -u $target -n 50 --no-pager";
    $logs = ssh2_exec_capture($connection, $cmd);
    echo json_encode(['status' => 'ok', 'service' => $target, 'logs' => explode(PHP_EOL, $logs)]);
    exit;

  default:
    // Standard: Liste aller Services
    $cmd = "systemctl list-units --type=service --no-pager --all --output=json";
    $output = ssh2_exec_capture($connection, $cmd);
    $services = json_decode($output, true);
    if (!$services) {
      // Fallback falls JSON-Ausgabe nicht unterstützt wird
      $fallback = ssh2_exec_capture($connection, "systemctl list-units --type=service --no-pager | tail -n +2 | awk '{print $1,$2,$3,$4,$5,$6}'");
      $lines = explode(PHP_EOL, $fallback);
      $services = [];
      foreach ($lines as $line) {
        $cols = preg_split('/\\s+/', trim($line));
        if (count($cols) >= 4) {
          $services[] = [
            'name' => $cols[0],
            'load' => $cols[1],
            'active' => $cols[2],
            'sub' => $cols[3],
          ];
        }
      }
    }
    echo json_encode(['status' => 'ok', 'count' => count($services), 'services' => $services]);
}
?>
