<?php
header('Content-Type: application/json');
$config = require __DIR__ . '/config.php';
$serverKey = $_GET['server'] ?? '';

if (!isset($config['servers'][$serverKey])) {
  echo json_encode(['error' => 'Unknown server']);
  exit;
}

$server = $config['servers'][$serverKey];

// Verbindung aufbauen
$connection = @ssh2_connect($server['host'], 22);
if (!$connection) {
  echo json_encode(['error' => 'SSH connection failed']);
  exit;
}
if (!@ssh2_auth_password($connection, $server['user'], $server['pass'])) {
  echo json_encode(['error' => 'Authentication failed']);
  exit;
}

// Funktion für SSH-Ausgabe
function ssh2_exec_capture($conn, $cmd) {
  $stream = ssh2_exec($conn, $cmd);
  stream_set_blocking($stream, true);
  $result = stream_get_contents($stream);
  fclose($stream);
  return trim($result);
}

// Prozesse abrufen
$cmd = "ps -eo pid,comm,stat,%cpu,%mem --sort=-%cpu | head -n 30";
$output = ssh2_exec_capture($connection, $cmd);

$lines = explode(PHP_EOL, trim($output));
array_shift($lines); // Header entfernen, falls vorhanden

$processes = [];
foreach ($lines as $line) {
  $cols = preg_split('/\\s+/', trim($line));
  if (count($cols) >= 5) {
    $processes[] = [
      'pid' => (int)$cols[0],
      'name' => $cols[1],
      'status' => $cols[2],
      'cpu' => (float)$cols[3],
      'mem' => (float)$cols[4]
    ];
  }
}

echo json_encode([
  'status' => 'ok',
  'count' => count($processes),
  'processes' => $processes
]);
?>
