<?php
header('Content-Type: application/json');
require __DIR__ . '/common.php';

$action = $_REQUEST['action'] ?? 'list';

switch ($action) {
    case 'list':
        $data = madmin_load_servers();
        echo json_encode([
            'status'  => 'ok',
            'servers' => $data['servers']
        ]);
        break;

    case 'save':
        $id   = trim($_REQUEST['id']   ?? '');
        $name = trim($_REQUEST['name'] ?? '');
        $host = trim($_REQUEST['host'] ?? '');
        $port = (int)($_REQUEST['port'] ?? 22);
        $user = trim($_REQUEST['user'] ?? '');
        $pass = trim($_REQUEST['pass'] ?? '');

        if ($id === '' || $name === '' || $host === '' || $user === '' || $pass === '') {
            madmin_json_error('Missing required fields (id, name, host, user, pass)');
        }

        $data = madmin_load_servers();
        $found = false;
        foreach ($data['servers'] as &$srv) {
            if (isset($srv['id']) && $srv['id'] === $id) {
                $srv['name'] = $name;
                $srv['host'] = $host;
                $srv['port'] = $port;
                $srv['user'] = $user;
                $srv['pass'] = $pass;
                $found = true;
                break;
            }
        }
        unset($srv);

        if (!$found) {
            $data['servers'][] = [
                'id'   => $id,
                'name' => $name,
                'host' => $host,
                'port' => $port,
                'user' => $user,
                'pass' => $pass
            ];
        }

        if (!madmin_save_servers($data)) {
            madmin_json_error('Failed to save servers.json');
        }
        echo json_encode(['status' => 'ok']);
        break;

    case 'delete':
        $id = trim($_REQUEST['id'] ?? '');
        if ($id === '') {
            madmin_json_error('Missing id');
        }
        $data = madmin_load_servers();
        $new = [];
        foreach ($data['servers'] as $srv) {
            if (!isset($srv['id']) || $srv['id'] !== $id) {
                $new[] = $srv;
            }
        }
        $data['servers'] = $new;
        if (!madmin_save_servers($data)) {
            madmin_json_error('Failed to save servers.json');
        }
        echo json_encode(['status' => 'ok']);
        break;

    default:
        madmin_json_error('Unknown action');
}
