<?php
header('Content-Type: application/json');
require __DIR__ . '/common.php';

list($server, $conn) = madmin_require_server_from_request();

// robust über dpkg -l + awk
$cmd = "/usr/bin/dpkg -l 2>/dev/null | /usr/bin/awk '/^ii/ { printf \"%s %s\\n\", \$2, \$3 }' | head -n 200";
$out = madmin_ssh_exec_capture($conn, $cmd);

$packages = [];
if ($out !== '') {
    $lines = explode("\n", $out);
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line === '') continue;
        $parts = preg_split('/\s+/', $line, 2);
        if (count($parts) === 2) {
            $packages[] = [
                'name'    => $parts[0],
                'version' => $parts[1]
            ];
        }
    }
}

echo json_encode([
    'status'   => 'ok',
    'server'   => $server['id'] ?? '',
    'count'    => count($packages),
    'packages' => $packages
]);
