<?php
header('Content-Type: application/json');
$config = require __DIR__ . '/config.php';
$serverKey = $_GET['server'] ?? '';
if (!isset($config['servers'][$serverKey])) {
  echo json_encode(['error' => 'Unknown server']);
  exit;
}

$server = $config['servers'][$serverKey];
$connection = @ssh2_connect($server['host'], 22);
if (!$connection) { echo json_encode(['error' => 'SSH connection failed']); exit; }
if (!@ssh2_auth_password($connection, $server['user'], $server['pass'])) {
  echo json_encode(['error' => 'Authentication failed']); exit;
}

function ssh2_exec_capture($conn, $cmd) {
  $stream = ssh2_exec($conn, $cmd);
  stream_set_blocking($stream, true);
  $result = stream_get_contents($stream);
  fclose($stream);
  return trim($result);
}

$cpu = trim(ssh2_exec_capture($connection, "top -bn1 | grep 'Cpu(s)' | awk '{print 100 - $8}'"));
$mem = trim(ssh2_exec_capture($connection, "free | grep Mem | awk '{print $3/$2 * 100.0}'"));
$disk = trim(ssh2_exec_capture($connection, "df -h / | tail -1 | awk '{print $5}' | sed 's/%//'"));
$net  = ssh2_exec_capture($connection, "cat /proc/net/dev | tail -n +3 | awk '{rx+=$2; tx+=$10} END {print rx,tx}'");
list($rx, $tx) = explode(' ', trim($net));

echo json_encode([
  'cpu' => round((float)$cpu, 1),
  'ram' => round((float)$mem, 1),
  'disk' => round((float)$disk, 1),
  'network' => ['rx' => round($rx / 1024, 1), 'tx' => round($tx / 1024, 1)],
  'status' => 'ok'
]);
?>
