<?php
header('Content-Type: application/json');
require __DIR__ . '/common.php';

$cmd     = $_REQUEST['cmd']     ?? '';
$timeout = (int)($_REQUEST['timeout'] ?? 60);

if ($cmd === '') {
    madmin_json_error('No command');
}

list($server, $conn) = madmin_require_server_from_request();

$stream = @ssh2_exec($conn, "export PATH=/usr/bin:/bin:/usr/sbin:/sbin; " . $cmd . " 2>&1");
if (!$stream) {
    madmin_json_error('ssh2_exec failed');
}
stream_set_blocking($stream, true);
stream_set_timeout($stream, $timeout);
$out = stream_get_contents($stream);
$meta = stream_get_meta_data($stream);
fclose($stream);

// Exitcode separat abfragen
$rc_stream = @ssh2_exec($conn, "echo $?");
stream_set_blocking($rc_stream, true);
$rc = (int)trim(stream_get_contents($rc_stream));
fclose($rc_stream);

echo json_encode([
    'status'    => 'ok',
    'server'    => $server['id'] ?? '',
    'command'   => $cmd,
    'exitcode'  => $rc,
    'timed_out' => !empty($meta['timed_out']),
    'output'    => $out
]);
