<?php
// downloader.php – Einfacher File-Downloader für Daniel

// Ordner, aus dem Dateien geladen werden dürfen
$baseDir = '/var/www/';

// Name der Datei aus GET?
if (!isset($_GET['file']) || empty($_GET['file'])) {
    header('Content-Type: text/plain');
    echo "Keine Datei angegeben.\nBeispiel-Aufruf:\n?file=admin-webgui.zip";
    exit;
}

$file = basename($_GET['file']); // Sicherheitsmaßnahme
$fullPath = $baseDir . $file;

// Datei existiert?
if (!file_exists($fullPath)) {
    header('Content-Type: text/plain');
    echo "Die Datei wurde nicht gefunden: $file";
    exit;
}

// Header für Download
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . $file . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($fullPath));

// Datei streamen
readfile($fullPath);
exit;
?>
